-- Somali Truck

GT = {};
GT_t.ws = 0;
set_recursive_metatable(GT, GT_t.generic_wheel_vehicle);
set_recursive_metatable(GT.chassis, GT_t.CH_t.bhd_somali_truck_chassis);
GT.chassis.mass = GT.chassis.mass + 80;   --1740=1660+80kg DShK

GT.visual.shape = "bhd_somali_truck";	
GT.visual.shape_dstr = "kamaz-tent-p_1";

GT.animation_arguments.pitch_k = 1.5;
GT.animation_arguments.roll_k = 1.5;

GT.IR_emission_coeff = 0.08

GT.swing_on_run = false;

GT.sensor = {};
set_recursive_metatable(GT.sensor, GT_t.SN_visual);
GT.sensor.height = 2.826;

GT.windscreen_wiper = 40
GT.animation_arguments.crew_presence = 50;

--destruction  
GT.agony_fire_pos_y = 0.982;
GT.agony_fire_pos_y = 1.725;
GT.agony_fire_pos_z = 0.315;

--Burning after hit
GT.visual.fire_size = 0.65; --relative burning size
GT.visual.fire_pos[1] = 0.2; -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 0.8; -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = 0; -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 300; --burning time (seconds)
GT.visual.min_time_agony = 10;
GT.visual.max_time_agony = 120;
GT.visual.agony_explosion_size = 2;

GT.visual.IR = { coeffs = {GT_t.IR_COEFFS_ENGINE_APC, GT_t.IR_COEFFS_WHEELS_Car, GT_t.IR_COEFFS_HMG, IR_COEFFS_BODY, {0.21, 0.21/1050}}}

GT.driverCockpit = "DriverCockpit/DriverCockpit"
GT.driverViewConnectorName = "POINT_DRIVER"



GT.Name = "bhd_somali_truck";
GT.DisplayName = _("BHD - Somali Truck");
GT.DisplayNameShort = _("STrck");
GT.Rate = 6;
GT.Crew = 1;

GT.DetectionRange  = 0;
GT.ThreatRange = 0;
GT.mapclasskey = "P0091000212";
GT.attribute = {wsType_Ground,wsType_Tank,wsType_NoWeapon,wsType_GenericVehicle,
				"Trucks",
				};
GT.category = "Unarmed";
GT.tags  =
{
    "Unarmed",
	"Civilian",
}
add_surface_unit(GT)